<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGeneralInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('general_infos', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('inventory_id')->unsigned();
            $table->integer('site_id')->unsigned()->nullable();
            $table->integer('um_id')->unsigned();
            $table->integer('type_id')->unsigned();
            $table->string('type');
            $table->double('cost');
            $table->double('qty');
			$table->integer('category_id')->unsigned()->nullable();
			$table->double('width')->nullable();
            $table->double('height')->nullable();
			$table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('general_infos');
    }
}
