<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBuildDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('build_details', function (Blueprint $table) {
            $table->increments('id');
            $table->string('type');
            $table->integer('item_id')->unsigned();
            $table->integer('um_id')->unsigned();
            $table->integer('build_id')->unsigned();
            $table->double('quantity');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('build_details');
    }
}
