<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectItemTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_item_transactions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('assembly_id')->unsigned();
            $table->integer('inventory_id')->unsigned();
            $table->integer('cost_transaction')->unsigned();
            $table->integer('income_transaction')->unsigned();
            $table->integer('asset_transaction')->unsigned();
			$table->string('type')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_item_transactions');
    }
}
