<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMeasureExchangesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('measure_exchanges', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('from_um_id')->unsigned();
            $table->integer('to_um_id')->unsigned();
            $table->double('exchange_rate')->nullable();
            $table->string('type')->default('same');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('measure_exchanges');
    }
}
