<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectBuildItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_build_items', function (Blueprint $table) {
            
			$table->increments('id');
            $table->string('type');
            $table->integer('item_id')->unsigned();
            $table->integer('um_id')->unsigned();
            $table->integer('project_build_id')->unsigned();
            $table->integer('project_details_id')->unsigned();
            $table->double('qty');
			$table->double('cost')->nullable();
			$table->string('item_type')->nullable();
			$table->integer('project_items_id')->nullable();
            $table->timestamps();
			
			
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_build_items');
    }
}
