<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectBuildsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_builds', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('project_id')->unsigned();
            $table->integer('assembly_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->text('description')->nullable();
            $table->datetime('date');
			$table->double('qty')->nullable();
			$table->double('cost')->nullable();
            $table->integer('number')->nullable();
            $table->integer('expense_transaction')->unsigned();
            $table->integer('cost_transaction')->unsigned();
			$table->string('type');
			$table->double('code')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_builds');
    }
}
