<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectStockOutsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_stock_outs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('project_build_id')->unsigned();
            $table->integer('project_stock_id')->unsigned();
            $table->integer('asset_t_id')->unsigned();
            $table->double('qty');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_stock_outs');
    }
}
