<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_stocks', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('project_id')->unsigned();
            $table->integer('project_item_id')->unsigned();
            $table->integer('stock_out_id')->unsigned();
            $table->text('description')->nullable();
            $table->date('date_in')->nullable();
			$table->double('qty');
			$table->double('cost')->nullable();
			$table->integer('inventory_id')->unsigned()->nullable();
			$table->integer('inventory_site_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_stocks');
    }
}
