<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_services', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('project_id')->unsigned();
            $table->integer('item_id')->unsigned();
            $table->double('price');
            $table->double('quantity');
            $table->boolean('status')->default(0);
            $table->integer('um_id')->unsigned();
            $table->string('type')->nullable();
			$table->integer('income_transaction')->unsigned();
			$table->integer('cost_transaction')->unsigned();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_services');
    }
}
