<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGlassesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('glasses', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('project_id')->unsigned();
            $table->double('height');
            $table->double('width');
            $table->integer('measure_id')->unsigned();
            $table->string('window_type');
            $table->string('spencer_size')->nullable();
            $table->text('description')->nullable();
			$table->integer('site_id')->unsigned()->nullable();
			$table->integer('parent_id')->unsigned()->nullable();
			$table->double('qty');
			$table->integer('item_id')->unsigned();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('glasses');
    }
}
