<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->double('number');
            $table->integer('customer_id')->unsigned();
            $table->datetime('start_date');
            $table->datetime('end_date')->nullable();
            $table->string('location')->nullable();
            $table->string('province')->nullable();
            $table->string('district')->nullable();
            $table->string('currency');
            $table->double('rate');
            $table->string('color')->nullable();
            $table->double('maintainance_duration')->nullable();
            $table->string('work_type')->nullable();
            $table->string('type');
            $table->string('discount_type');
            $table->text('description')->nullable();
			$table->integer('work_type_id')->unsigned();
			$table->integer('project_progress_id')->unsigned();
			$table->integer('discount_transaction')->unsigned();
			$table->integer('project_transaction')->unsigned();
			$table->string('income_transaction')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('projects');
    }
}
