<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_transfers', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('from_member_id')->unsigned();
            $table->integer('to_member_id')->unsigned();
            $table->integer('from_sale_id')->unsigned()->nullable();
            $table->integer('from_purchase_id')->unsigned()->nullable();
            $table->integer('to_sale_id')->unsigned()->nullable();
            $table->integer('to_purchase_id')->unsigned()->nullable();
            $table->datetime('date')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_transfers');
    }
}
