<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->increments('id');
            $table->string('logo')->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->string('type')->nullable();
            $table->string('calculation_method')->nullable();
            $table->string('phone')->nullable();
            $table->string('color')->nullable();
            $table->smallInteger('tag',false)->nullable();
            $table->unsignedInteger('system_config_id',false)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
