<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSalesOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('sales_orders', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('member_id')->unsigned()->nullable();
			$table->string('currency');
			$table->double('rate')->default(1);
            $table->decimal('discount', 5, 2)->default(0);
            $table->string('discount_type')->nullable();
		    $table->string('description');
            $table->datetime('date')->nullable();
            $table->string('type')->nullable();
			$table->datetime('delivery_date')->nullable();
            $table->boolean('status')->nullable()->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_orders');
    }
}
