<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loans', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('member_id');
            $table->integer('account_id');
            $table->integer('contract_id')->nullable();
            $table->integer('bank_transaction');
            $table->integer('loan_transaction');
            $table->datetime('date');
            $table->datetime('due_date');
            $table->char('type');
            $table->double('rate', 8, 8);
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loans');
    }
}
