<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSendMoneysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('send_moneys', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('contract_id');
            $table->integer('account_id');
            $table->integer('transaction_id');
            $table->integer('receivable_id');
            $table->double('rate')->default(1);
            $table->datetime('date');
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('send_moneys');
    }
}
