<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContractsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contracts', function (Blueprint $table) {
            $table->increments('id');
            $table->string('company_name'); 
            $table->integer('member_id'); 
            $table->string('contract_no');
            $table->integer('receivable_id');
            $table->integer('account_id')->unsigned();
            $table->integer('transaction_id')->unsigned();
            $table->double('rate')->default(1);
            $table->datetime('date');
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contracts');
    }
}
