<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReceivablePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('receivable_payments', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('member_id');
            $table->integer('bank_transaction');
            $table->double('rate', 18, 8);
            $table->double('hq_rate', 18, 8)->nullable();
            $table->datetime('date');
            $table->double('discount')->default(0);
            $table->integer('receivable_transaction');
            $table->char('type');
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('receivable_payments');
    }
}
