<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('employee_id');
            $table->datetime('from_date');
            $table->datetime('to_date');
            $table->integer('expense_transaction');
            $table->integer('payable_transaction');
            $table->integer('salary_id')->nullable();
            $table->integer('expense_id')->nullable();
            $table->double('rate')->default(1);
            $table->double('worked_day',6);
            $table->double('paid_leave',4)->nullable();
            $table->char('type')->nullable();
            $table->double('amount')->nullable();
            $table->double('fee')->nullable();
            $table->double('overtime_addition',8)->nullable();
            $table->double('net_payable',8);
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payrolls');
    }
}
