<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMemberInformationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_informations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('address1')->nullable();
            $table->string('address2')->nullable();
            $table->char('city',50)->nullable();
            $table->integer('member_id')->unsigned();
            $table->char('country',50)->nullable();
            $table->datetime('date_of_birth')->nullable();
            $table->datetime('reg_date')->nullable();
            $table->char('membership',50)->nullable();
            $table->char('gender',50)->nullable();
            $table->char('post_code',50)->nullable();
            $table->integer('class_id')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_informations');
    }
}
