<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStockOutsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stock_outs', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('stock_id')->unsigned();
            $table->integer('sale_id')->unsigned();
            $table->integer('sale_um_id')->unsigned();
            $table->integer('inventory_id')->unsigned();
            $table->integer('customer_id')->unsigned();
            $table->datetime('date_out');
            $table->integer('user_id')->unsigned();
            $table->double('qut_out')->unsigned();
            $table->double('sales_price')->unsigned();
            $table->boolean('status')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_outs');
    }
}
