<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('items', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->unsigned();
            $table->integer('account_id')->unsigned();
            $table->integer('service_class_id')->unsigned()->nullable();
            $table->integer('parent_id')->nusigned()->default(0);
            $table->integer('um_id')->unsigned()->default(0);
            $table->double('rate')->default(0);
            $table->integer('number')->unsigned()->default(null);
            $table->string('name');
            $table->string('type');
            $table->integer('tax_code')->unsigned()->default(0);
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('items');
    }
}
